import math

class Point2D:
    def __init__(self, x, y):
        if x < 0 or y < 0:
            raise Exception("Blad: Punkt2D")
        self.__x = x
        self.__y = y        

    def get_x(self):
        return self.__x
    
    def set_x(self, x):
        if x >= 0:
            self.__x = x
        

    def get_y(self):
        return self.__y

    def set_x(self, y):
        if y >= 0:
            self.__y = y
        
    def dist_to(self, p):
        return abs(math.sqrt((self.get_x() - p.get_x())**2 + (self.get_y() - p.get_y())**2))

    def mirror(self):
        return Point2D(-self.__x, self.__y)
    
    def __str__(self):
        return "Point2D(%s, %s)" % (self.__x, self.__y)

if __name__ == "__main__":
    p1 = Point2D(1, 2)
    # p2 = Point2D(-1, 2)
    print "Pole prywatne:", p1._Point2D__x
    print p1
    
    